<?php
// email.php - Email helper za TapTap Card

class EmailService {
    private $smtp_host = 'mail.taptap.ba';
    private $smtp_port = 465;
    private $smtp_user = 'no-reply@taptap.ba';
    private $smtp_pass = 'G]Vj0dI3myJ9=PZ]';
    private $from_email = 'no-reply@taptap.ba';
    private $from_name = 'TapTap Card';
    
    public function sendPasswordReset($to, $token) {
        $reset_link = "https://card.taptap.ba/user-reset-password.php?token=" . $token;
        
        $subject = "Resetiraj lozinku - TapTap Card";
        $message = "
        <html>
        <body style='font-family: Arial, sans-serif; line-height: 1.6;'>
            <h2>Resetiranje lozinke</h2>
            <p>Zatražili ste resetiranje lozinke za vaš TapTap Card account.</p>
            <p>Kliknite na link ispod da resetirate lozinku:</p>
            <p><a href='{$reset_link}' style='background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>Resetiraj lozinku</a></p>
            <p>Link vrijedi 1 sat.</p>
            <p>Ako niste zatražili resetiranje, ignorirajte ovaj email.</p>
            <hr>
            <p style='color: #666; font-size: 12px;'>TapTap Card - Digital Business Cards</p>
        </body>
        </html>
        ";
        
        return $this->send($to, $subject, $message);
    }
    
    public function sendContactMessage($user_email, $sender_name, $sender_email, $message_text) {
        $subject = "Nova poruka sa vaše TapTap kartice - od {$sender_name}";
        $message = "
        <html>
        <body style='font-family: Arial, sans-serif; line-height: 1.6;'>
            <h2>Nova poruka sa vaše TapTap kartice</h2>
            <p><strong>Od:</strong> {$sender_name}</p>
            <p><strong>Email:</strong> {$sender_email}</p>
            <hr>
            <p><strong>Poruka:</strong></p>
            <p>" . nl2br(htmlspecialchars($message_text)) . "</p>
            <hr>
            <p style='color: #666; font-size: 12px;'>TapTap Card - Digital Business Cards</p>
        </body>
        </html>
        ";
        
        return $this->send($user_email, $subject, $message);
    }
    
    public function sendWelcomeEmail($to, $name, $temp_password) {
        $login_link = "https://card.taptap.ba/user-login.php";
        
        $subject = "Dobrodošli na TapTap Card!";
        $message = "
        <html>
        <body style='font-family: Arial, sans-serif; line-height: 1.6;'>
            <h2>Dobrodošli, {$name}!</h2>
            <p>Vaš TapTap Card account je kreiran.</p>
            <p><strong>Email:</strong> {$to}</p>
            <p><strong>Privremena lozinka:</strong> {$temp_password}</p>
            <p><a href='{$login_link}' style='background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>Prijavite se</a></p>
            <p><strong>Važno:</strong> Promijenite lozinku nakon prve prijave.</p>
            <hr>
            <p style='color: #666; font-size: 12px;'>TapTap Card - Digital Business Cards</p>
        </body>
        </html>
        ";
        
        return $this->send($to, $subject, $message);
    }
    
    public function sendAccountCreatedEmail($createdByName, $createdByRole, $newUserData) {
        $to = 'info@taptap.ba';
        $subject = 'Čestitamo, novi account je kreiran';
        
        $package = $newUserData['package'] ?? 'basic';
        $slug = $newUserData['slug'] ?? 'N/A';
        $ime = $newUserData['ime'] ?? '';
        $prezime = $newUserData['prezime'] ?? '';
        $email = $newUserData['email'] ?? 'N/A';
        $profileUrl = "https://card.taptap.ba/{$slug}";
        $activeStatus = $newUserData['active'] ? 'DA' : 'NE';
        $activeFrom = $newUserData['active_from'] ?? 'odmah';
        $activeUntil = $newUserData['active_until'] ?? 'lifetime';
        $datum = date('d.m.Y H:i');
        
        $message = "
        <html>
        <body style='font-family: monospace; line-height: 1.6; background: #f5f5f5; padding: 20px;'>
            <div style='background: white; padding: 30px; border-left: 4px solid #3b82f6;'>
                <h2 style='color: #3b82f6; margin-top: 0;'>═══════════════════════════════════════</h2>
                <h2 style='text-align: center; color: #1e40af;'>NOVI TAPTAP CARD ACCOUNT KREIRAN</h2>
                <h2 style='color: #3b82f6;'>═══════════════════════════════════════</h2>
                
                <table style='width: 100%; margin: 20px 0;'>
                    <tr>
                        <td style='padding: 8px 0;'><strong>KREIRAO:</strong></td>
                        <td style='padding: 8px 0;'>{$createdByName} ({$createdByRole})</td>
                    </tr>
                    <tr>
                        <td style='padding: 8px 0;'><strong>DATUM:</strong></td>
                        <td style='padding: 8px 0;'>{$datum}</td>
                    </tr>
                </table>
                
                <hr style='border: 1px solid #e5e7eb; margin: 20px 0;'>
                
                <h3 style='color: #1e40af;'>NOVI KORISNIK:</h3>
                <table style='width: 100%;'>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Ime:</strong></td>
                        <td style='padding: 5px 0;'>{$ime} {$prezime}</td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Slug:</strong></td>
                        <td style='padding: 5px 0;'>{$slug}</td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Email:</strong></td>
                        <td style='padding: 5px 0;'>{$email}</td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Paket:</strong></td>
                        <td style='padding: 5px 0;'><span style='background: #3b82f6; color: white; padding: 2px 8px; border-radius: 3px;'>" . strtoupper($package) . "</span></td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Profil:</strong></td>
                        <td style='padding: 5px 0;'><a href='{$profileUrl}' style='color: #3b82f6;'>{$profileUrl}</a></td>
                    </tr>
                </table>
                
                <hr style='border: 1px solid #e5e7eb; margin: 20px 0;'>
                
                <h3 style='color: #1e40af;'>STATUS:</h3>
                <table style='width: 100%;'>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Aktivan:</strong></td>
                        <td style='padding: 5px 0;'>{$activeStatus}</td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Aktivan od:</strong></td>
                        <td style='padding: 5px 0;'>{$activeFrom}</td>
                    </tr>
                    <tr>
                        <td style='padding: 5px 0;'>• <strong>Aktivan do:</strong></td>
                        <td style='padding: 5px 0;'>{$activeUntil}</td>
                    </tr>
                </table>
                
                <h2 style='color: #3b82f6; margin-bottom: 0;'>═══════════════════════════════════════</h2>
            </div>
        </body>
        </html>
        ";
        
        return $this->send($to, $subject, $message);
    }
    
    private function send($to, $subject, $message) {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: {$this->from_name} <{$this->from_email}>\r\n";
        $headers .= "Reply-To: {$this->from_email}\r\n";
        
        // PHPMailer alternative - za production preporučam PHPMailer library
        // Za sada koristim PHP mail() sa SMTP podešavanjima
        
        $success = mail($to, $subject, $message, $headers);
        
        if (!$success) {
            error_log("Email send failed to: {$to}");
        }
        
        return $success;
    }
}
