<?php
require_once 'config.php';

$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);
$path = trim($path, '/');

if ($path === 'admin' || $path === 'admin.php') {
    header('Location: /admin.php');
    exit;
}

if (strpos($path, 'api/') === 0) {
    include 'api.php';
    exit;
}

$slug = $path ?: null;
if (!$slug) die('Neispravan URL');

$db = getDB();
$stmt = $db->prepare('SELECT * FROM users WHERE slug = ?');
$stmt->execute([$slug]);
$user = $stmt->fetch();

if (!$user) die('Korisnik nije pronađen');

$stmt = $db->prepare('SELECT * FROM links WHERE user_id = ? ORDER BY sort_order');
$stmt->execute([$user['id']]);
$links = $stmt->fetchAll();

$stmt = $db->prepare('SELECT * FROM modules WHERE user_id = ? AND aktivan = 1');
$stmt->execute([$user['id']]);
$modules = $stmt->fetchAll();

$activeModules = [];
foreach ($modules as $module) {
    $activeModules[$module['modul_name']] = $module;
}

// Log visit
$ip = getUserIP();
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$qrScan = isset($_GET['qr']) && $_GET['qr'] == '1' ? 1 : 0;
$stmt = $db->prepare('INSERT INTO visits (user_id, ip, user_agent, qr_scan) VALUES (?, ?, ?, ?)');
$stmt->execute([$user['id'], $ip, $userAgent, $qrScan]);

// Učitaj odabrani template
$template = $user['display_template'] ?? 'modern';

if ($template === 'business') {
    include 'template-business.php';
} else {
    include 'template-modern.php';
}
?>